-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("ironQuest")
  self:AddTriggerTarget("ironQuestMsg")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.completed = 0
      self.msgAdded = false
      self.msgDeact = false
    end
  end
  
  if self.msgAdded and not self.msgDeact then
    self.p0:AddQuest('D02_IRON', 'side')
    self.msgDeact = true
  end
  
  if self.completed == 2 then
    self.p0:AddResource(3, 240)
    self.p0:AddResource(7, 60)
    self.p0:WinQuest('D02_IRON')
		self.p0:UnlockCharacter("D_Meleagant")
    self.completed = false
  end
end

function OnTrigger(self, source, target)
  if target == "ironQuest" then
    self.completed = self.completed + 1
  elseif target == "ironQuestMsg" then
    self.msgAdded = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
    self.completed = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.completed)
  end
end
